/*
 * Decompiled with CFR 0.152.
 */
package flash.io;

import exploit.control.AppControl;
import flash.io.BitInput;
import java.io.IOException;

public class BitLibrary {
    private BitInput myBitInput;
    private boolean isDebug;

    public BitLibrary(BitInput bitInput) {
        this.myBitInput = bitInput;
        this.isDebug = AppControl.getInfo().getDebug();
        if (this.isDebug) {
            System.out.println("Bit Library: Active");
        }
    }

    public long sb(int n) throws IOException {
        long l = this.myBitInput.readBits(n, false);
        if ((l & 1L << n - 1) != 0L) {
            l |= -1L << n;
        }
        return l;
    }

    public long ub(int n) throws IOException {
        return this.myBitInput.readBits(n, false);
    }

    public long sbl(int n) throws IOException {
        long l = this.myBitInput.readBits(n, true);
        if ((l & 1L << n - 1) != 0L) {
            l |= -1L << n;
        }
        return l;
    }

    public long ubl(int n) throws IOException {
        return this.myBitInput.readBits(n, true);
    }

    public float fb(int n) throws IOException {
        return (float)this.sb(n) / 65536.0f;
    }

    public long si8() throws IOException {
        return (byte)this.ui8();
    }

    public long si16() throws IOException {
        return (short)this.ui16();
    }

    public long si32() throws IOException {
        return (int)this.ui32();
    }

    public long[] si8(int n) throws IOException {
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.si8();
        }
        return lArray;
    }

    public long[] si16(int n) throws IOException {
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.si16();
        }
        return lArray;
    }

    public long[] si32(int n) throws IOException {
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.si32();
        }
        return lArray;
    }

    public long ui8() throws IOException {
        return this.myBitInput.readByte();
    }

    public long ui16() throws IOException {
        long l = 0L;
        long l2 = 0L;
        l2 += (long)this.myBitInput.readByte();
        l = this.myBitInput.readByte();
        return l2 += (l <<= 8);
    }

    public long ui32() throws IOException {
        long l = 0L;
        long l2 = 0L;
        l2 += (long)this.myBitInput.readByte();
        l = this.myBitInput.readByte();
        l2 += (l <<= 8);
        l = this.myBitInput.readByte();
        l2 += (l <<= 16);
        l = this.myBitInput.readByte();
        return l2 += (l <<= 24);
    }

    public byte[] uiBytes(int n) throws IOException {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)this.ui8();
        }
        return byArray;
    }

    public long[] ui8(int n) throws IOException {
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.ui8();
        }
        return lArray;
    }

    public long[] ui16(int n) throws IOException {
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.ui16();
        }
        return lArray;
    }

    public long[] ui32(int n) throws IOException {
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.ui32();
        }
        return lArray;
    }

    public float fixed() throws IOException {
        return Float.intBitsToFloat((int)this.si32());
    }
}

